/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayout;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;

public abstract class AbstractStationSlotLayoutProvider
extends GenericDataProvider {
    protected static final int SORT_WEAPON = 3;
    protected static final int SORT_HARVEST = 6;
    protected static final int SORT_LARGE = 6;
    private final Map<ResourceLocation, StationSlotLayout.Builder> allLayouts = new HashMap<ResourceLocation, StationSlotLayout.Builder>();

    public AbstractStationSlotLayoutProvider(DataGenerator generator) {
        super(generator, PackType.SERVER_DATA, "tinkering/station_layouts", StationSlotLayoutLoader.GSON);
    }

    protected abstract void addLayouts();

    protected StationSlotLayout.Builder define(ResourceLocation id) {
        return this.allLayouts.computeIfAbsent(id, i -> StationSlotLayout.builder());
    }

    protected StationSlotLayout.Builder define(ItemLike item) {
        return this.define(Objects.requireNonNull(item.m_5456_().getRegistryName()));
    }

    protected StationSlotLayout.Builder defineModifiable(IModifiableDisplay item) {
        return this.define(Objects.requireNonNull(item.m_5456_().getRegistryName())).translationKey(item.m_5456_().m_5524_()).icon(item.getRenderTool());
    }

    protected StationSlotLayout.Builder defineModifiable(Supplier<? extends IModifiableDisplay> item) {
        return this.defineModifiable(item.get());
    }

    public void m_6865_(HashCache cache) throws IOException {
        this.addLayouts();
        this.allLayouts.forEach((id, builder) -> this.saveThing(cache, (ResourceLocation)id, builder.build()));
    }
}

